#include "pch.h"

#include "Mem.hpp"
#include "Common.hpp"
#include "CfgParse.hpp"
#include "Misc.hpp"

#include "Links.h"
#include "LinksManager.h"

#include "Areas.h"
#include "AreasManager.h"

#include "Msg.hpp"
#include "Tic.hpp"
#include "crc32.hpp"
#include "Temp.hpp"
#include "File.h"

#include "CfgLexems.hpp"
#include "WELexems.h"

#include "MsgAttrs.h"

#include "Adrenalin.h"


/**
 * Implementation of ProcessFixRequests
 */


void CAdrenalin::ProcessFixRequests(bool flagByHand /* = false */) {
    TCHAR   processStartTime[64];
    GetTimeForLog( processStartTime );

    WIN32_FIND_DATA FindFileData;
	HANDLE          hFindFile;
	BOOL            fFileFound;
	TCHAR           szFindFileMask[MAX_PATH];
	TCHAR           szFullFileName[MAX_PATH];
	TCHAR           szLogLine[MAX_PATH];
	int             nMailPathLen;
	int             nProcessedMsgNumber;
	vector<tstring>	vsMsgFileNames;
	CMsg		msg;
	vector<tstring>	vsBodyLines;
	TCHAR           szLine[LINE_SIZE];
	TCHAR           szReplySubject[72];
	int             i;
	int             nSubscribeNumber, nFoundNumber;
	bool            fNewMessagesCreated; // if created we should create FixFlag
    vector<tstring> requestsLogData;

	lstrcpy( szFindFileMask, g_vars.m_szNetmailPath );
	lstrcpy( szFullFileName, g_vars.m_szNetmailPath );
	nMailPathLen = lstrlen( g_vars.m_szNetmailPath );
	lstrcpy( szFindFileMask + nMailPathLen, _T("*.msg") );

	nProcessedMsgNumber = 0;

	if (flagByHand) {
        g_vars.m_log << CLog::ResetSingle(new CLog::StdErr())
                     << TEXT("Processing Fix requests from command line:\n")
                     << CLog::Pop();
        g_vars.m_log << CLog::ResetSingle(new CLog::StdOut());
		// set sender
		if (!ParseLinkAddr( m_handCommands.m_sAddr.c_str(), msg.m_addrTo )) {
			g_vars.m_log << TEXT("[!] Error: failed to parse link address\n")
                         << CLog::Pop();
			return;
		}
		// check link
		PLink	link = CLinksManager::getInstance()->getLink( msg.m_addrTo );
		if (link == NULL) {
			g_vars.m_log << TEXT("[!] Error: unknown link\n")
                         << CLog::Pop();
			return;
		}
		// set sender
		strcpy( msg.m_Header.m_szToUserName, "SysOp" );
		// set receiver (we well reply)
		msg.m_addrFrom = link->getOurAddress();
		strcpy( msg.m_Header.m_szFromUserName, "Adrenalin" );
		msg.Reply( ATTR_PRIVATE | ATTR_LOCAL, 0, link->getPassword().c_str(), m_handCommands.m_vsCommands );
		vsMsgFileNames.push_back( msg.m_szLastReplyFileName );
	}
	else {
		g_vars.m_log << CLog::ResetSingle(new CLog::StdErr())
			     << TEXT("Processing Fix requests in directory ")
			     << g_vars.m_szNetmailPath << TEXT(" : \n")
			     << CLog::Pop();

		hFindFile = FindFirstFile( szFindFileMask, &FindFileData );
		fFileFound = (hFindFile != INVALID_HANDLE_VALUE);
		while (fFileFound) {
		    vsMsgFileNames.push_back( g_vars.m_szNetmailPath );
		    vsMsgFileNames.back() += FindFileData.cFileName;
		    fFileFound = FindNextFile( hFindFile, &FindFileData );
		}
		if (hFindFile != INVALID_HANDLE_VALUE)
		FindClose( hFindFile );
	}
    
	// setup log
	g_vars.m_log << CLog::SetSingle(new CLog::FileOut());

    fNewMessagesCreated = false;
    vector<tstring>::iterator	itCurMsgFileName = vsMsgFileNames.begin();
    while (itCurMsgFileName != vsMsgFileNames.end()) {
        if (g_vars.m_fLogMsgNames) {
		    g_vars.m_log << TEXT("* msg: ") 
			             << (*itCurMsgFileName).c_str() 
        			     << TEXT_EOL;
        }
        if (msg.Read( (*itCurMsgFileName).c_str() )) {
            if (g_vars.m_fLogMsgNames) {
		        g_vars.m_log << TEXT("       read\n");
            }
            if (g_vars.m_fKillProcessedMail)
                msg.Delete();
            else
                msg.SaveAsReceived();
            // check link
			PLink	link = CLinksManager::getInstance()->getLink( msg.m_addrFrom );
            if (link != NULL) {
				bool	fToUs = (AddrCmp( msg.m_addrTo, link->getOurAddress() ) == 0);
                if (!fToUs) {
                    // ignore message;
                    // only add line into log file
                    g_vars.m_log << _T("  message not for corresponding AKA:\r\n");
                    g_vars.m_log << _T("    from ");
		            msg.m_addrFrom.ToString( szLogLine );
		            g_vars.m_log << szLogLine;
		            msg.m_addrTo.ToString( szLogLine );
		            g_vars.m_log << _T(" to ") << szLogLine << _T("\r\n");
                }
                else if (link->getActivity() == ACTIVITY_UNAVAILABLE) {
                    // unavailable system
                    _stprintf( szLine, m_language[LNG_UNAVAILABLE_INFO],
                             g_vars.m_szSysOp );
                    vsBodyLines.push_back( szLine );
                    msg.Reply( g_vars.m_nReplyMessageAttrs, 
							   g_vars.m_nReplyMessageFlags,
                               m_language[LNG_UNAVAILABLE_INFO_SUBJ],
                               vsBodyLines );
                    fNewMessagesCreated = true;
                    vsBodyLines.clear();
                    g_vars.m_log << _T("  message from unavailable system:\r\n    ");
		            msg.m_addrFrom.ToString( szLogLine );
                    g_vars.m_log << szLogLine << _T("\r\n");
                }
                else if (lstrcmpi( link->getPassword().c_str(), msg.m_szSubject ) == 0)
                {
                    if (g_vars.m_vMsgData.empty()) {
                        // no commands used
                        vsBodyLines.push_back( m_language[LNG_NO_COMMANDS_USED] );
                        msg.Reply( g_vars.m_nReplyMessageAttrs,
								   g_vars.m_nReplyMessageFlags,
                                   m_language[LNG_NO_COMMANDS_USED_SUBJ],
                                   vsBodyLines );
                        fNewMessagesCreated = true;
                        vsBodyLines.clear();
                    }
                    else {
                        // process unknown commands
                        vsBodyLines.push_back( m_language[LNG_UNKNOWN_COMMANDS] );
                        nSubscribeNumber = 0;
                        vector<SMsgData>::iterator	itCurMsgData = g_vars.m_vMsgData.begin();
                        while (itCurMsgData != g_vars.m_vMsgData.end()) {
                            if ((*itCurMsgData).m_iType == MSGDATA_COMMAND &&
                                lstrcmpi( (*itCurMsgData).m_sLine.c_str(), TEXT("help")) != 0 &&
                                lstrcmpi( (*itCurMsgData).m_sLine.c_str(), TEXT("list")) != 0 &&
                                lstrcmpi( (*itCurMsgData).m_sLine.c_str(), TEXT("query")) != 0 &&
                                lstrcmpi( (*itCurMsgData).m_sLine.c_str(), TEXT("linked")) != 0 &&
                                lstrcmpi( (*itCurMsgData).m_sLine.c_str(), TEXT("unlinked")) != 0 &&
                                lstrcmpi( (*itCurMsgData).m_sLine.c_str(), TEXT("lock")) != 0 &&
                                lstrcmpi( (*itCurMsgData).m_sLine.c_str(), TEXT("unlock")) != 0 &&
				                lstrcmpi( (*itCurMsgData).m_sLine.c_str(), TEXT("pause")) != 0 &&
				                lstrcmpi( (*itCurMsgData).m_sLine.c_str(), TEXT("resume")) != 0 &&
				                lstrcmpi( (*itCurMsgData).m_sLine.c_str(), TEXT("resend")) != 0 &&
				                lstrcmpi( (*itCurMsgData).m_sLine.c_str(), TEXT("avail")) != 0)
                            {
                                _stprintf( szLine, _T("  %%%s"), (*itCurMsgData).m_sLine.c_str() );
                                vsBodyLines.push_back( szLine );
                                nSubscribeNumber++;
                                (*itCurMsgData).m_iType = MSGDATA_NONE;
                            }
                            itCurMsgData++;
                        }
                        if (nSubscribeNumber > 0) {
                            msg.Reply( g_vars.m_nReplyMessageAttrs,
				                       g_vars.m_nReplyMessageFlags,
                                       m_language[LNG_UNKNOWN_COMMANDS_SUBJ],
                                       vsBodyLines );
                            fNewMessagesCreated = true;
                        }
                        vsBodyLines.clear();
                        // process known commands and subscriptions
                        vsBodyLines.push_back( m_language[LNG_SUBSCRIPTION_CHANGES] );
                        nSubscribeNumber = 0;
                        itCurMsgData = g_vars.m_vMsgData.begin();
                        // store recipient address in requests log if have any requests
                        if (itCurMsgData != g_vars.m_vMsgData.end()) {
                            lstrcpy( szLogLine, TEXT("Processing requests from ") );
                            msg.m_addrFrom.ToString( szLogLine + lstrlen(szLogLine) );
                            requestsLogData.push_back( szLogLine );
                        }
                        // go through all commands
                        while (itCurMsgData != g_vars.m_vMsgData.end()) {
                            switch ((*itCurMsgData).m_iType) {

                            case MSGDATA_SUBSCRIBE:

                                // logging request
                                _stprintf( szLogLine, TEXT("Subscribing to '%s'"),
                                           (*itCurMsgData).m_sLine.c_str() );
                                requestsLogData.push_back( szLogLine );

                                nSubscribeNumber++;
                                nFoundNumber = 0;
								{
									int	areasCount = CAreasManager::getInstance()->getAreasCount();
									for (int i = 0; i < areasCount; i++) {
										PArea	area = CAreasManager::getInstance()->getArea( i );
										if (CheckMask( area->getName().c_str(), (*itCurMsgData).m_sLine.c_str() )) {
											if (area->getTie( link ) != NULL) {
												// already linked
												_stprintf( szLine, m_language[LNG_AREA_ALREADY_LINKED],
														   area->getName().c_str() );
												_stprintf( szLogLine, TEXT( "Already linked to '%s'" ),
														   area->getName().c_str() );
												requestsLogData.push_back( szLogLine );
											}
											else {
												if (area->canReceive( link ) || area->canSend( link )) {
													TiePtr	tie = new CTie();
													tie->setLink( link );
													tie->setRouteType( ROUTE_NONE );
													area->addTie( tie );

													// linked

													CAreasManager::getInstance()->affectAreas();

													_stprintf( szLine, m_language[LNG_AREA_LINKED], area->getName().c_str() );
													_stprintf( szLogLine, TEXT( "Linked to '%s'" ), area->getName().c_str() );
													requestsLogData.push_back( szLogLine );
												}
												else {
													// no access
													_stprintf( szLine, m_language[LNG_AREA_NO_ACCESS], area->getName().c_str() );
													_stprintf( szLogLine, TEXT( "No access to '%s'" ), area->getName().c_str() );
													requestsLogData.push_back( szLogLine );
												}
											}
											vsBodyLines.push_back( szLine );
											nFoundNumber++;
										}					    
									}
								}
                                if (nFoundNumber == 0) {
					                if (IsMask(const_cast<TCHAR*>((*itCurMsgData).m_sLine.c_str()))) {
                                        // no area sutisfies mask
						                _stprintf( szLine, m_language[LNG_AREA_MASK_NOT_FOUND],
							                (*itCurMsgData).m_sLine.c_str() );
						                vsBodyLines.push_back( szLine );
                                        _stprintf( szLogLine, TEXT("No area found for mask '%s'"),
                                                   (*itCurMsgData).m_sLine.c_str() );
                                        requestsLogData.push_back( szLogLine );
					                }
					            else {
						char	szOemLine[LINE_SIZE];
						// trying to forward request
						PLink	forwardLink = NULL;
						for (CLinksManager::CIterator itLink = CLinksManager::getInstance()->begin();
							 itLink != CLinksManager::getInstance()->end(); ++itLink)
						{
							// skip requestor
							if (AddrCmp( (*itLink)->getAddress(), msg.m_addrFrom ) == 0) {
								continue;
							}
							// check AvailAreas
							if ((*itLink)->getAvailAreasFileName().length() == 0) {
								continue;
							}
							// open areas file
							char	szOemFileName[MAX_PATH];
							CharToOem( (*itLink)->getAvailAreasFileName().c_str(), szOemFileName );
							ifstream	in(szOemFileName);
							if (in.fail()) {
								continue;
							}
							bool	fAreaFound = false;
							while (!in.eof() && !fAreaFound) {
								in.getline( szOemLine, LINE_SIZE );
								if (in.fail())
									break;
								OemToChar( szOemLine, szLine );
								fAreaFound = (lstrcmpi( szLine, (*itCurMsgData).m_sLine.c_str() ) == 0);
							}
							in.close();
							if (fAreaFound) {
								forwardLink = (*itLink);
								break;
							}
						}
						if (forwardLink != NULL) {
							// link to forward found
                            _stprintf( szLogLine, TEXT("Forwarding request for '%s' to "),
                                       (*itCurMsgData).m_sLine.c_str() );
                            forwardLink->getAddress().ToString( szLogLine + lstrlen(szLogLine) );
                            requestsLogData.push_back( szLogLine );
							// write message to this link
							CMsg			forwardMsg;
							vector<tstring>	vsForwardBody;
							// print log message
							g_vars.m_log << _T("Forwarding request from ");
							msg.m_addrFrom.ToString( szLine );
							g_vars.m_log << szLine << _T(" to ");
							forwardLink->getAddress().ToString( szLine );
							g_vars.m_log << szLine << _T("\r\n\011requesting ") << (*itCurMsgData).m_sLine.c_str() << _T("\r\n");

							_stprintf( szLine, _T("+%s"), (*itCurMsgData).m_sLine.c_str() );
							vsForwardBody.push_back( szLine );
							MakeDirStructure( g_vars.m_szNetmailPath );
							// from/to fields reversed because we will use reply method
							forwardMsg.m_addrFrom = forwardLink->getAddress();
							forwardMsg.m_addrTo   = forwardLink->getOurAddress();
							if (forwardLink->getRobotName().length() > 0)
								CharToOem( forwardLink->getRobotName().c_str(), forwardMsg.m_Header.m_szFromUserName );
							else
								strcpy( forwardMsg.m_Header.m_szFromUserName, "AllFix" );
							CharToOem( g_vars.m_szSysOp, forwardMsg.m_Header.m_szToUserName );
							forwardMsg.m_lFreeMsgNumber = msg.m_lFreeMsgNumber;
							forwardMsg.Reply( ATTR_PRIVATE | ATTR_LOCAL, 0, forwardLink->getPassword().c_str(), vsForwardBody );
							msg.m_lFreeMsgNumber++;
							g_vars.m_log << _T("Forward request message created.\r\n");
							// add line
							_stprintf( szLine, m_language[LNG_REQUEST_FORWARDED],
								(*itCurMsgData).m_sLine.c_str() );
							vsBodyLines.push_back( szLine );
							// 2. Let's keep track of requestors
							if (!m_fForwardsRead) {
								LoadForwards();
							}
							// 3. Add new forward info, format of date is DDMMYY
							SForwardInfo	fwdInfo;
							SYSTEMTIME	systemTime;
							GetLocalTime( &systemTime );
							_stprintf( fwdInfo.m_szDate, _T("%02d%02d%02d"), systemTime.wDay, systemTime.wMonth, systemTime.wYear % 100 );
							_stprintf( fwdInfo.m_szLink, _T("%d:%d/%d.%d@%s"), msg.m_addrFrom.Zone, msg.m_addrFrom.Net, msg.m_addrFrom.Node, msg.m_addrFrom.Point, msg.m_addrFrom.Domain );
							lstrcpy( fwdInfo.m_szArea, (*itCurMsgData).m_sLine.c_str() );
							m_vectForwardInfo.push_back( fwdInfo );
							m_fForwardsChanged = true;
						}
						else {
                            // area not found
							_stprintf( szLine, m_language[LNG_AREA_NOT_FOUND],
								(*itCurMsgData).m_sLine.c_str() );
							vsBodyLines.push_back( szLine );
                            _stprintf( szLogLine, TEXT("Not found '%s'"), (*itCurMsgData).m_sLine.c_str() );
                            requestsLogData.push_back( szLogLine );
						}
					}
                                    
                                }
                                break;

                            case MSGDATA_UNSUBSCRIBE:

                                // logging request
                                _stprintf( szLogLine, TEXT("Unsubscribing from '%s'"),
                                           (*itCurMsgData).m_sLine.c_str() );
                                requestsLogData.push_back( szLogLine );

                                nSubscribeNumber++;
                                nFoundNumber = 0;
								{
									int	areasCount = CAreasManager::getInstance()->getAreasCount();
									for (int i = 0; i < areasCount; i++) {
										PArea	area = CAreasManager::getInstance()->getArea( i );
										if (CheckMask( area->getName().c_str(), (*itCurMsgData).m_sLine.c_str() )) {											
											if (area->removeTie( link )) {
												// unlinked

												CAreasManager::getInstance()->affectAreas();

												_stprintf( szLine, m_language[LNG_AREA_UNLINKED], area->getName().c_str() );
												vsBodyLines.push_back( szLine );
												nFoundNumber++;
												_stprintf( szLogLine, TEXT("Unlinked from '%s'"), area->getName().c_str() );
												requestsLogData.push_back( szLogLine );
											}
											else if (!IsMask((*itCurMsgData).m_sLine.c_str())) {
												// not linked
												_stprintf( szLine, m_language[LNG_AREA_NOT_LINKED],
														   area->getName().c_str() );
												vsBodyLines.push_back( szLine );
												nFoundNumber++;
												_stprintf( szLogLine, TEXT("Was not linked to '%s'"), area->getName().c_str() );
												requestsLogData.push_back( szLogLine );
											}

										}
										
									}
								}
                                if (nFoundNumber == 0) {
                                    if (IsMask((*itCurMsgData).m_sLine.c_str())) {
                                        _stprintf( szLine, m_language[LNG_AREA_MASK_NOT_FOUND],
                                                 (*itCurMsgData).m_sLine.c_str() );
                                        _stprintf( szLogLine, TEXT("No area found for mask '%s'"),
                                                   (*itCurMsgData).m_sLine.c_str() );
                                    }
                                    else {
                                        _stprintf( szLine, m_language[LNG_AREA_NOT_FOUND],
                                                 (*itCurMsgData).m_sLine.c_str() );
                                        _stprintf( szLogLine, TEXT("Not found '%s'"),
                                                   (*itCurMsgData).m_sLine.c_str() );
                                    }
                                    vsBodyLines.push_back( szLine );
                                    requestsLogData.push_back( szLogLine );
                                }
                                break;

                            case MSGDATA_COMMAND:

								const char*	command = (*itCurMsgData).m_sLine.c_str();

                                // logging request
                                _stprintf( szLogLine, TEXT("Requesting command '%s', tail = '%s'"),
                                           command, (*itCurMsgData).m_sTail.c_str() );
                                requestsLogData.push_back( szLogLine );

                                if (nSubscribeNumber > 0) {
                                    msg.Reply( g_vars.m_nReplyMessageAttrs,
					                           g_vars.m_nReplyMessageFlags,
                                               m_language[LNG_SUBSCRIPTION_CHANGES_SUBJ],
                                               vsBodyLines );
                                    fNewMessagesCreated = true;
                                    nSubscribeNumber = 0;
                                }
                                vsBodyLines.clear();
                                vsBodyLines.push_back(_T(""));

                                if (lstrcmpi( command, TEXT("help") ) == 0) {

									// HELP command

                                    lstrcpy( szReplySubject, m_language[LNG_HELP_SUBJ] );
                                    vsBodyLines.push_back( m_language[LNG_HELP_HEAD] );
                                    if (!g_vars.m_vsAliases.empty()) {
                                        vsBodyLines.push_back( m_language[LNG_HELP_ALIASES] );
                                        for (i = 1; i < g_vars.m_vsAliases.size(); i++) {
                                            _stprintf( szLine, _T("  %s"), g_vars.m_vsAliases[i] );
                                            vsBodyLines.push_back( szLine );
                                        }
					                    vsBodyLines.push_back( _T("") );
                                    }
                                    vsBodyLines.push_back( m_language[LNG_HELP] );
                                    requestsLogData.push_back( TEXT("Help sent") );

                                }
                                else if (lstrcmpi( command, TEXT("resend") ) == 0) {

									// RESEND command

									lstrcpy( szReplySubject, m_language[LNG_RESEND_SUBJECT] );
									ProcessResendCommand( link, (*itCurMsgData), vsBodyLines );

								}
                                else if (lstrcmpi( command, TEXT("list") ) == 0) {
	
									// LIST command

									// answer on %list
									lstrcpy( szReplySubject, m_language[LNG_LIST_SUBJ] );

									int	areasCount = 0;

									VTString	areasList;

									CAreasManager::CGroupIterator	groupEnd  = CAreasManager::getInstance()->groupEnd();
									for (CAreasManager::CGroupIterator groupIter = CAreasManager::getInstance()->groupBegin();
										 groupIter != groupEnd; ++groupIter)
									{
										PAreaGroup	group = (*groupIter);
										bool		groupPrinted = false;

										CAreasManager::CAreaIterator	areaEnd = CAreasManager::getInstance()->areaEnd( group );
										for (CAreasManager::CAreaIterator areaIter = CAreasManager::getInstance()->areaBegin( group );
											 areaIter != areaEnd; ++areaIter)
										{
											PArea	area = (*areaIter);

											bool	canReceive = area->canReceive( link );
											bool	canSend    = area->canSend( link );
											
											if (canReceive || canSend) {

												++areasCount;

												if (!groupPrinted) {
													groupPrinted = true;
													// print group name
													_stprintf( szLine, TEXT("  %s %s: %s"), m_language[LNG_GROUP], group->getName().c_str(), group->getDescription().c_str() );
													areasList.push_back( TEXT("") );
													areasList.push_back( TEXT("  ============================================================================") );
													areasList.push_back( szLine );
													areasList.push_back( TEXT("  ============================================================================") );
													areasList.push_back( TEXT("") );
												}

												std::string	nameDesc;
												area->getNameDesc( nameDesc );

												ConstTiePtr	tie = area->getTie( link );
												if (tie != NULL) {
													switch (tie->getRouteType()) {
													case ROUTE_RECEIVE:
														nameDesc[1] = TEXT('R');
														break;
													case ROUTE_SEND:
														nameDesc[1] = TEXT('S');
														break;
													case ROUTE_BIDIRECT:
														nameDesc[1] = TEXT('B');
														break;
													case ROUTE_NONE:
														break;
													}
													nameDesc[0] = TEXT('+');
												}
												if (tie == NULL || tie->getRouteType() == ROUTE_NONE) {
													if (canReceive) {
														if (canSend) {
															nameDesc[1] = TEXT('B');
														}
														else {
															nameDesc[1] = TEXT('R');
														}
													}
													else {
														if (canSend) {
															nameDesc[1] = TEXT('S');
														}
													}
												}
												areasList.push_back( nameDesc );
											}						
										}
									}

									if (areasCount == 0) {
										vsBodyLines.push_back( m_language[LNG_LIST_EMPTY] );
									}
									else {
										_stprintf( szLine, m_language[LNG_LIST_TITLE], areasCount );
										vsBodyLines.push_back( szLine );
										for (int i = 0; i < areasList.size(); i++) {
											vsBodyLines.push_back( areasList[i] );
										}
										vsBodyLines.push_back( m_language[LNG_LIST_MARKS_TITLE] );
										vsBodyLines.push_back( m_language[LNG_MARKS] );
									}

									requestsLogData.push_back( TEXT("List of accessible areas sent") );
                                }
                                else if (lstrcmpi( command, TEXT("query") ) == 0 ||
                                         lstrcmpi( command, TEXT("linked") ) == 0)
                                {

									// QUERY/LINKED command

									// answer on %query or %linked
                                    lstrcpy( szReplySubject, m_language[LNG_LINKED_SUBJ] );

									int	areasCount = 0;

									VTString	areasList;

									CAreasManager::CGroupIterator	groupEnd  = CAreasManager::getInstance()->groupEnd();
									for (CAreasManager::CGroupIterator groupIter = CAreasManager::getInstance()->groupBegin();
										 groupIter != groupEnd; ++groupIter)
									{
										PAreaGroup	group = (*groupIter);
										bool		groupPrinted = false;

										CAreasManager::CAreaIterator	areaEnd = CAreasManager::getInstance()->areaEnd( group );
										for (CAreasManager::CAreaIterator areaIter = CAreasManager::getInstance()->areaBegin( group );
											 areaIter != areaEnd; ++areaIter)
										{
											PArea		area = (*areaIter);
											ConstTiePtr	tie  = area->getTie( link );
											if (tie != NULL) {

												++areasCount;

												if (!groupPrinted) {
													groupPrinted = true;
													// print group name
													_stprintf( szLine, TEXT("  %s %s: %s"), m_language[LNG_GROUP], group->getName().c_str(), group->getDescription().c_str() );
													areasList.push_back( TEXT("") );
													areasList.push_back( TEXT("  ============================================================================") );
													areasList.push_back( szLine );
													areasList.push_back( TEXT("  ============================================================================") );
													areasList.push_back( TEXT("") );
												}
												std::string	nameDesc;
												area->getNameDesc( nameDesc );

												bool	canReceive = area->canReceive( link );
												bool	canSend    = area->canSend( link );

												switch (tie->getRouteType()) {
												case ROUTE_RECEIVE:
													nameDesc[0] = TEXT('R');
													break;
												case ROUTE_SEND:
													nameDesc[0] = TEXT('S');
													break;
												case ROUTE_BIDIRECT:
													nameDesc[0] = TEXT('B');
													break;
												case ROUTE_NONE:
													if (canReceive) {
														if (canSend) {
															nameDesc[0] = TEXT('B');
														}
														else {
															nameDesc[0] = TEXT('R');
														}
													}
													else {
														if (canSend) {
															nameDesc[0] = TEXT('S');
														}
													}
													break;
												}
												areasList.push_back( nameDesc );
											}
										}
									}

									if (areasCount == 0) {
										vsBodyLines.push_back( m_language[LNG_LINKED_EMPTY] );
									}
									else {
										_stprintf( szLine, m_language[LNG_LINKED_TITLE], areasCount );
										vsBodyLines.push_back( szLine );
										for (int i = 0; i < areasList.size(); i++) {
											vsBodyLines.push_back( areasList[i] );
										}
										vsBodyLines.push_back( m_language[LNG_LINKED_MARKS_TITLE] );
										vsBodyLines.push_back( m_language[LNG_MARKS] );
									}
                                    requestsLogData.push_back( TEXT("List of linked areas sent") );
                                }
                                else if (lstrcmpi( command, TEXT("unlinked") ) == 0) {

									// UNLINKED command

									// answer on %unlinked
                                    lstrcpy( szReplySubject, m_language[LNG_UNLINKED_SUBJ] );

									int	areasCount = 0;

									VTString	areasList;

									CAreasManager::CGroupIterator	groupEnd  = CAreasManager::getInstance()->groupEnd();
									for (CAreasManager::CGroupIterator groupIter = CAreasManager::getInstance()->groupBegin();
										 groupIter != groupEnd; ++groupIter)
									{
										PAreaGroup	group = (*groupIter);
										bool		groupPrinted = false;

										CAreasManager::CAreaIterator	areaEnd = CAreasManager::getInstance()->areaEnd( group );
										for (CAreasManager::CAreaIterator areaIter = CAreasManager::getInstance()->areaBegin( group );
											 areaIter != areaEnd; ++areaIter)
										{
											PArea	area = (*areaIter);

											bool	canReceive = area->canReceive( link );
											bool	canSend    = area->canSend( link );
																				
											if ((canReceive || canSend) && (area->getTie( link ) == NULL)) {

												++areasCount;

												if (!groupPrinted) {
													groupPrinted = true;
													// print group name
													_stprintf( szLine, TEXT("  %s %s: %s"), m_language[LNG_GROUP], group->getName().c_str(), group->getDescription().c_str() );
													areasList.push_back( TEXT("") );
													areasList.push_back( TEXT("  ============================================================================") );
													areasList.push_back( szLine );
													areasList.push_back( TEXT("  ============================================================================") );
													areasList.push_back( TEXT("") );
												}
												std::string	nameDesc;
												area->getNameDesc( nameDesc );
												areasList.push_back( nameDesc );
											}						
										}
									}

									if (areasCount == 0) {
										vsBodyLines.push_back( m_language[LNG_UNLINKED_EMPTY] );
									}
									else {
										_stprintf( szLine, m_language[LNG_UNLINKED_TITLE], areasCount );
										vsBodyLines.push_back( szLine );
										for (int i = 0; i < areasList.size(); i++) {
											vsBodyLines.push_back( areasList[i] );
										}
									}
                                    requestsLogData.push_back( TEXT("List of linked areas sent") );
                                }
                                else if (lstrcmpi( command, TEXT("lock") ) == 0 ||
										 lstrcmpi( command, TEXT("pause") ) == 0)
								{

									// LOCK/PAUSE command

                                    lstrcpy( szReplySubject, m_language[LNG_LOCK_SUBJ] );
                                    if (link->getActivity() == ACTIVITY_USUAL) {
                                        link->setActivity( ACTIVITY_PASSIVE );

										CLinksManager::getInstance()->affectLinks();

                                        vsBodyLines.push_back( m_language[LNG_LOCK] );
                                        requestsLogData.push_back( TEXT("Locked") );
                                    }
                                    else {
                                        vsBodyLines.push_back( m_language[LNG_ALREADY_LOCKED] );
                                        requestsLogData.push_back( TEXT("Already locked") );
                                    }
                                    vsBodyLines.push_back( m_language[LNG_UNLOCK_NOTIFY] );
                                }
                                else if (lstrcmpi( command, TEXT("unlock") ) == 0 ||
										 lstrcmpi( command, TEXT("resume") ) == 0)
								{

									// UNLOCK/RESUME command

                                    lstrcpy( szReplySubject, m_language[LNG_UNLOCK_SUBJ] );
                                    if (link->getActivity() == ACTIVITY_PASSIVE) {
                                        link->setActivity( ACTIVITY_USUAL );

										CLinksManager::getInstance()->affectLinks();

                                        vsBodyLines.push_back( m_language[LNG_UNLOCK] );
                                        requestsLogData.push_back( TEXT("Unlocked") );
                                    }
                                    else {
                                        vsBodyLines.push_back( m_language[LNG_NOT_LOCKED] );
                                        requestsLogData.push_back( TEXT("Was not locked") );
                                    }
                                    vsBodyLines.push_back( m_language[LNG_LOCK_NOTIFY] );
                                }
								else if (lstrcmpi( command, TEXT("avail") ) == 0) {

									// AVAIL command

									lstrcpy( szReplySubject, m_language[LNG_AVAIL_LIST_SUBJECT] );

									char		oemLine[LINE_SIZE];
									VTString	availAreas;

									for (CLinksManager::CIterator itLink = CLinksManager::getInstance()->begin();
										 itLink != CLinksManager::getInstance()->end(); ++itLink)
									{
										PLink	availLink = (*itLink);
										// skip requestor
										if (AddrCmp( availLink->getAddress(), msg.m_addrFrom ) == 0) {
											continue;
										}
										// check AvailAreas
										if (availLink->getAvailAreasFileName().length() == 0) {
											continue;
										}
										// open areas file
										char	szOemFileName[MAX_PATH];
										CharToOem( availLink->getAvailAreasFileName().c_str(), szOemFileName );
										ifstream	in(szOemFileName);
										if (in.fail()) {
											continue;
										}
										while (!in.eof()) {
											in.getline( oemLine, LINE_SIZE );
											if (in.fail())
												break;
											OemToChar( oemLine, szLine );
											// keep only nonempty lines
											if (*szLine != TEXT('\0')) {
												availAreas.push_back( szLine );
											}
										}
										in.close();
									}
									
									// check number of available areas
									if (availAreas.empty()) {
										// no available areas
										vsBodyLines.push_back( m_language[LNG_AVAIL_LIST_EMPTY] );
									}
									else {
										vsBodyLines.push_back( m_language[LNG_AVAIL_LIST_HEAD] );
										AppendVector( vsBodyLines, availAreas );
									}

									requestsLogData.push_back( TEXT("List of uplink-available areas sent") );
								}
								msg.Reply( g_vars.m_nReplyMessageAttrs,
				 						   g_vars.m_nReplyMessageFlags,
										   szReplySubject, vsBodyLines );
								fNewMessagesCreated = true;
								vsBodyLines.clear();
								vsBodyLines.push_back( m_language[LNG_SUBSCRIPTION_CHANGES] );
								nSubscribeNumber = 0;
								break;
							};
                            itCurMsgData++;
                        }
                        if (nSubscribeNumber > 0) {
                            msg.Reply( g_vars.m_nReplyMessageAttrs,
									   g_vars.m_nReplyMessageFlags,
                                       m_language[LNG_SUBSCRIPTION_CHANGES_SUBJ],
                                       vsBodyLines );
                            fNewMessagesCreated = true;
                            nSubscribeNumber = 0;
                        }
                    }
                }
                else {
                    // incorrect password
                    _stprintf( szLine, m_language[LNG_INCORRECT_PASSWORD],
                               msg.m_szSubject, g_vars.m_szSysOp );
                    vsBodyLines.push_back( szLine );
                    msg.Reply( g_vars.m_nReplyMessageAttrs,
							   g_vars.m_nReplyMessageFlags,
                               m_language[LNG_ACCESS_DENIED_SUBJ],
                               vsBodyLines );
                    fNewMessagesCreated = true;
                    vsBodyLines.clear();
                }
            }
            else {
                // link is not listed
                _stprintf( szLine, m_language[LNG_UNKNOWN_USER], msg.m_szToUserName, g_vars.m_szSysOp );
                vsBodyLines.push_back( szLine );
                msg.Reply( g_vars.m_nReplyMessageAttrs, g_vars.m_nReplyMessageFlags,
                           m_language[LNG_ACCESS_DENIED_SUBJ],
                           vsBodyLines );
                fNewMessagesCreated = true;
                vsBodyLines.clear();
            }
            g_vars.FreeMsgData();
            nProcessedMsgNumber++;
        }
        else {
            if (g_vars.m_fLogMsgNames)
                g_vars.m_log << TEXT("       failed\n");
        }
		itCurMsgFileName++;
    }
    if (fNewMessagesCreated && *g_vars.m_szFixFlagName != _T('\0'))
        CreateFileFlag( g_vars.m_szFixFlagName );

    g_vars.m_log << CLog::ResetSingle(new CLog::StdErr())
                 << TEXT("Fix done.\n")
                 << CLog::Pop();

    // restore log modes
    g_vars.m_log << CLog::Pop();

    // write requests log
    if (!IsEmptyStr( requestsLogFileName ) && !requestsLogData.empty()) {
        CFile   requestsLog;
        if (requestsLog.Open( requestsLogFileName, GENERIC_WRITE, OPEN_ALWAYS )) {
            requestsLog.SeekToEnd();
            requestsLog.WriteStringAsOem( processStartTime );
            requestsLog.WriteStringAsOem( TEXT_EOL );
            for (vector<tstring>::iterator   it = requestsLogData.begin();
                 it != requestsLogData.end(); it++)
            {                
                requestsLog.WriteStringAsOem( (*it).c_str() );
                requestsLog.WriteStringAsOem( TEXT_EOL );
            }
            // get end time into the processStartTime (use the same variable)
            GetTimeForLog( processStartTime );
            requestsLog.WriteStringAsOem( processStartTime );
            requestsLog.WriteStringAsOem( TEXT_EOL );
            requestsLog.WriteStringAsOem( TEXT_EOL );
            requestsLog.Close();
        }
        else {
            g_vars.m_log << CLog::ResetSingle( new CLog::StdOut() )
                         << TEXT("Failed to open requests log file: ")
                         << requestsLogFileName
                         << TEXT_EOL
                         << CLog::Pop();
        }
    }
}
